﻿#pragma   once

/// Window イベントハンドルのリソース管理を行うためのラッパークラス。
class EventHandle
{
public:

  EventHandle();
  explicit EventHandle(HANDLE hEvent);

  ~EventHandle();

  operator HANDLE ();

  void Wait() const;
  bool Wait(u32 timeout) const;
  void Set();
  void Reset();

private:

  EventHandle(const EventHandle &rhs);
  EventHandle &operator=(const EventHandle &rhs);

  HANDLE m_hEvent;
};
